/*
 * Decompiled with CFR 0.152.
 */
package lib.toma.animations.api;

import lib.toma.animations.AnimationUtils;
import lib.toma.animations.api.IAnimation;

public abstract class TickableAnimation
implements IAnimation {
    private final int length;
    private int ticksRemaining;
    private float progress;
    private float progressOld;
    private float progressInterpolated;

    public TickableAnimation(int length) {
        this.length = length;
        this.ticksRemaining = length;
    }

    @Override
    public final void renderTick(float deltaRenderTime) {
        float old = this.progressInterpolated;
        this.progressInterpolated = AnimationUtils.linearInterpolate(this.progress, this.progressOld, deltaRenderTime);
        this.nextFrame(this.progressInterpolated, old);
    }

    public float getProgress() {
        return 1.0f - (float)this.ticksRemaining / (float)this.length;
    }

    public float getInterpolatedProgress() {
        return this.progressInterpolated;
    }

    @Override
    public void gameTick() {
        --this.ticksRemaining;
        this.progressOld = this.progress;
        this.progress = this.getProgress();
    }

    @Override
    public boolean hasFinished() {
        return this.ticksRemaining <= 0;
    }

    public void nextFrame(float actualProgress, float previousProgress) {
    }
}

